using System;
using Server;
using Server.Gumps;
using Server.Network;
using Server.Items;
using Server.Mobiles;
using Server.Commands;
using Server.Engines.XmlSpawner2;

namespace Server.Gumps
{
	public class KingGump : Gump
	{
		private Mobile m_King;
		
		public KingGump( Mobile king ) : base( 50,50 )
		{
			m_King = king;
			//----------------------------------------------------------------------------------------------------

			AddPage( 0 );
			AddImageTiled(  54, 33, 369, 400, 2624 );
			AddAlphaRegion( 54, 33, 369, 400 );

			AddImageTiled( 416, 39, 44, 389, 203 );
			//--------------------------------------Window size bar--------------------------------------------
			
			AddImage( 97, 49, 9004 );
			AddImageTiled( 58, 39, 29, 390, 10460 );
			AddImageTiled( 412, 37, 31, 389, 10460 );
			AddLabel( 140, 60, 1152, "Kral Artur" );
			AddImage( 430, 9, 10441);
			AddImageTiled( 40, 38, 17, 391, 9263 );
			AddImage( 6, 25, 10421 );
			AddImage( 34, 12, 10420 );
			AddImageTiled( 94, 25, 342, 15, 10304 );
			AddImageTiled( 40, 427, 415, 16, 10304 );
			AddImage( -10, 314, 10402 );
			AddImage( 56, 150, 10411 );
			// 			AddImage( 155, 120, 2103 );
			AddImage( 136, 84, 96 );
			
			AddPage( 1 );
			AddHtml( 107, 120, 300, 250, "<BODY>" +
			        "<BASEFONT COLOR=YELLOW>Vitej! Takze ty jsi prisel na nasi vyzvu o zachranu kralovstvi a zahnani zleho draka Auberona zpet za magickou barieru vytvorenou nasimi magy?<BR>Je to jiz davno co tento netvor ovladal zemi, ale pak se ho podarilo nasim predkum uveznit hluboko v podzemi. Dnes uz si spousta lidi mysli ze je to pouze legenda a jedine co po nem zbylo je stale jeste jmeno nasi zeme, nyni se vsak opet probouzi k zivotu a zda se ze uz prekonal barieru a ted hleda cestu na povrch z podzemi kde je uveznen mocnym kouzlem.<BR>Rekni, troufas si na tento ukol? Odmena je velice lakava. Mocne brneni ci magicky toulec a spousta dalsich cennych veci.<BR><BR>" +
			        "K tomu, aby jsi se dostal(a) do drakova podzemniho vezeni potrebujes magickou nadobku, kterou vytvorili nasi magove a do ni nachytat deset druhu zvlastni magicke enregie, ktera vyvera v hlubinach zeme felucca.<BR>Pokud tedy ukol prijmes, dam ti tuto nadobku a tobe pak uz jen zbyde ji naplnit a najit vstup do podzemi kdesi v zemi Auberon, zemi ktera dala jmeno nasemu svetu a ted je to nehostina pustina ovladana nebezpecnymi monstry. Zda se ze se jich spousta usidlilo i v tom podzemi, takze nebude jednoduche se k drakovi dostat a jeste tezsi bude ho zahnat zpatky za barieru, protoze zabit ho nelze.<BR><BR>Prijimas tedy tento ukol?" +
			        "</BODY>", false, true);

			AddButton( 107, 384, 2224, 2224, 1, GumpButtonType.Reply, 0 );
			AddLabel(130, 380, 1152, @"Ano. Udelam vse pro zachranu nasi zeme");
			AddButton( 107, 404, 2224, 2224, 0, GumpButtonType.Reply, 0 );
			AddLabel(130, 400, 1152, @"Bohuzel, myslim ze je to nad me sily");
		}

		public override void OnResponse( NetState state, RelayInfo info )
		{
			Mobile from = state.Mobile;

			switch ( info.ButtonID )
			{
				case 0:
					{
						m_King.Say( "Dobra tedy, snad se najde nekdo, kdo bude mit vice odvahy." );
						break;
					}
					//=== Newbie contracts
				case 1:
					{
						if (XmlAttach.FindAttachment(from, typeof(HlavniQuest)) == null)
							XmlAttach.AttachTo(from, new HlavniQuest());
						
						HlavniQuest qatt = (HlavniQuest)XmlAttach.FindAttachment(from,typeof(HlavniQuest));
						
						qatt.InProgress = true;
						qatt.KilledDragon = false;
						qatt.Started = DateTime.Now;
						
						QuestJar qj = new QuestJar() as QuestJar;
						qj.Owner = from;
						from.AddToBackpack( qj );
						m_King.Say( "Vyborne, jsem rad ze se v nasi zemi jeste nejdou lide, kteri jsou ochotni za ni bojovat. Zde je ona zvlastni nadobka." );
						
						if ( qatt.Count < 1 )
						{
							BaseTalisman talisman = (BaseTalisman) new KingsTalisman();
							talisman.Owner = from;
							from.AddToBackpack( talisman );
							m_King.Say( "Jako dukaz uznani tve odvahy ti daruji i tento magicky amulet, snad ti na tve ceste pomuze." );
						}
						
						from.SendMessage( 34, "Prijmul{0} jsi hlavni quest, nikdy neztrat nadobku, nebo ho nebude mozne dokoncit! Realizacni tym shardu Auberon ti preje hodne stesti.", ( from.Female ) ? "a" : "" );
						break;
					}
			}
		}
	}
}
